#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""
功    能: 定义独立冗余磁盘阵列

版权信息: 华为技术有限公司，版权所有(C) 2022-2025

修改记录: 2023/7/11 18:00 created

"""


class CardFactoryMap(object):
    def __init__(self):
        self.card_map = {
            "lsi": Lsi,
            "hiraid": HiRaid,
            "pmc": Pmc
        }

    def get(self, target):
        """
        Args:
            target: mcs中的target
        Returns:
            None对象或者raid卡对象
        """
        if target == '--':
            return None
        card_type = target.split(":")[0]
        return self.card_map.get(card_type)()


class RaidCard(object):
    def __init__(self):
        self.chunk_size_tuple = (4096, 8192, 16384, 32768, 65536)

    def chunk_size(self):
        return self.chunk_size_tuple


class Lsi(RaidCard):
    def __init__(self):
        super(Lsi, self).__init__()


class HiRaid(RaidCard):
    def __init__(self):
        super(HiRaid, self).__init__()


class Pmc(RaidCard):
    def __init__(self):
        super(Pmc, self).__init__()
        self.chunk_size_tuple = (4096, 8192, 16384, 32768)
