#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""
功    能: 文件解压缩功能

版权信息: 华为技术有限公司，版权所有(C) 2023-2025

修改记录: 2023/8/11 15:46 created

"""
from lib.utils.command import CommandUtil


class Tar(object):
    def __init__(self):
        self.tar = "tar"

    def c_ignore_dir_path(self, src_dir, des_name):
        pack_cmd = "{} cvf {}.tar -C {} .".format(self.tar, des_name, src_dir)
        CommandUtil.exec_shell(pack_cmd)

    def c_contain_dir_path(self, src_dir, des_name):
        pack_cmd = "{} cvf {}.tar {}".format(self.tar, des_name, src_dir)
        CommandUtil.exec_shell(pack_cmd)

    def dc_specify_dir_path(self, src_name, des_dir):
        dc_cmd = "{} -zxvf {} -C {}".format(self.tar, src_name, des_dir)
        CommandUtil.exec_shell(dc_cmd)


class Zip(object):
    def __init__(self):
        self.unzip = "unzip"

    def dc_specify_dir_path(self, src_name, des_dir):
        dc_cmd = "{} -o {} -d {}".format(self.unzip, src_name, des_dir)
        CommandUtil.exec_shell(dc_cmd)
