#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""
功    能: 解析命令行参数

版权信息: 华为技术有限公司，版权所有(C) 2022-2025

修改记录: 2023/7/11 18:00 created

"""
from argparse import ArgumentParser, RawTextHelpFormatter


def cmd_line_parse():
    usage = "python3 dfs.py"
    parser = ArgumentParser(usage, formatter_class=RawTextHelpFormatter)
    parser.add_argument("-v", "--version", dest="version", action="store_true",
                        help="Show program's version number and exit")
    parser.add_argument("-o", dest="operation", help="specify the target operation\n"
                                                     "-o disks :scans all disk information on the server.\n"
                                                     "-o smart :collect SMART log about disks on the server.\n"
                                                     "-o internalLog :collect internal log about disks on the server.\n"
                                                     "-o internalLogProg :get the progress of collecting internal log\n"
                                                     "-o upgrade :upgrading the firmware of disks on the server\n"
                                                     "-o upgradeProg :get the progress of upgrading the firmware")
    parser.add_argument("-s", "--sn", dest="sn", help="specifying drives serial number.Ex:sn1,sn2..snk")
    parser.add_argument("-m", "--model", dest="model", help="specifying drives model number.Ex:model1,model2...modelk")
    return parser
