#!/usr/bin/env python
# -*- coding: UTF-8 -*-

"""
功    能: logger工具类

版权信息: 华为技术有限公司，版权所有(C) 2022-2025

修改记录: 2022/9/12 18:00 created

"""
import logging
import os
from logging import handlers


class LogUtil(object):
    def __init__(self, name, log_dir):
        """

        :param name:
        :param log_dir:
        :param logger_type:
        """
        self.log_name = os.path.join(log_dir, name)
        self.logger = logging.getLogger(name)
        self.logger.setLevel(logging.INFO)
        self.formatter = logging.Formatter(
            '[%(asctime)s][%(levelname)s]%(message)s')
        file_handler = logging.FileHandler(self.log_name)
        file_handler.setLevel(logging.INFO)
        file_handler.setFormatter(self.formatter)
        self.logger.addHandler(file_handler)
        console_handler = logging.StreamHandler()
        console_handler.setLevel(logging.INFO)
        console_handler.setFormatter(self.formatter)
        self.logger.addHandler(console_handler)
        file_handler.close()
        console_handler.close()

    def info(self, message, func_name=None):
        if not func_name:
            self.logger.info(message)
        else:
            self.logger.info("[Method:%s]-> " % func_name + message)

    def debug(self, message, func_name=None):
        if not func_name:
            self.logger.debug(message)
        else:
            self.logger.debug("[Method:%s]-> " % func_name + message)

    def warning(self, message, func_name=None):
        if not func_name:
            self.logger.warning(message)
        else:
            self.logger.warning("[Method:%s]-> " % func_name + message)

    def error(self, message, func_name=None):
        if not func_name:
            self.logger.error(message)
        else:
            self.logger.error("[Method:%s]-> " % func_name + message)

    def critical(self, message, func_name=None):
        if not func_name:
            self.logger.critical(message)
        else:
            self.logger.critical("[Method:%s]-> " % func_name + message)


class SimpleLogger(object):
    def __init__(self, file_name):
        '''
        日志初始化
        :param log_dir:
        :param name:
        '''
        # bug处理 日志目录没有则新建
        self.file_name = file_name
        self.logger = logging.getLogger(file_name)
        self.logger.setLevel(logging.DEBUG)
        format_str = logging.Formatter('%(asctime)s - %(levelname)s: %(message)s')
        run_handler = handlers.RotatingFileHandler(
            filename=os.path.join(".", file_name),
            maxBytes=1024 * 1024 * 20, backupCount=10, encoding='utf_8_sig'
        )
        run_handler.setFormatter(format_str)
        run_handler.setLevel(logging.DEBUG)
        self.logger.addHandler(run_handler)

    def debug(self, msg, *args, **kwargs):
        '''
        Debug 日志
        :param msg:
        :param args:
        :param kwargs:
        :return:
        '''
        self.logger.debug(msg, *args, **kwargs)

    def info(self, msg, *args, **kwargs):
        '''
        Info 日志
        :param msg:
        :param console_flag:
        :param args:
        :param kwargs:
        :return:
        '''
        self.logger.info(msg, *args, **kwargs)

    def warning(self, msg, *args, **kwargs):
        '''
        warning 日志
        :param msg:
        :param args:
        :param kwargs:
        :return:
        '''
        self.logger.warning(msg, *args, **kwargs)

    def error(self, msg, *args, **kwargs):
        '''
        error 日志
        :param msg:
        :param args:
        :param kwargs:
        :return:
        '''
        self.logger.error(msg, *args, **kwargs)

    def critical(self, msg, *args, **kwargs):
        '''
        critical 日志
        :param msg:
        :param args:
        :param kwargs:
        :return:
        '''
        self.logger.critical(msg, *args, **kwargs)

    def close(self):
        for handler in self.logger.handlers:
            handler.close()


class SingleLog(SimpleLogger):
    __instance = None

    def __new__(cls, *args, **kwargs):
        if not cls.__instance:
            cls.__instance = super(SingleLog, cls).__new__(cls)
        return cls.__instance

    def __init__(self):
        if not self.__dict__.get("logger", ""):
            file_name = "dfs.log"
            super(SingleLog, self).__init__(file_name)
